monteCarlo = function(M, disturbanceSize, growthRate){
  
  # DISTURBANCE
  neighbors = rollMatrix(M, n_directions = 8, operation = 'sum')
  resistance = (M + neighbors)/9#(5 + 4/sqrt(2))
  mortality = resistance < disturbanceSize
  M[mortality] = 0
  
  # GROWTH
  growth = rollMatrix(M, 4, operation = 'sum')*growthRate
  M = M + growth
  M[M > 1] = 1
  
  return(M)
}
